<?php
/**Used variables
 * @var User $EDITUSER
 * @var UserForm $UFORM
 * @var array $GROUPS
 */

/**
* @param string|null $err  the error string
*/
function is_invalid($err) {
    global $UFORM;
if (!is_null($err) && $UFORM->isSubmitted()) {
return ' is-invalid';
}

}

?>

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-dark"><b><?php print($EDITUSER->getShib()) ?></b> felhasználó adatainak módosítása</h1>
    </div>
    <div class="text-dark">
        <div>
            <div>
                <h5>Név módosítása:</h5>
            </div>
            <div>
                <textarea class="form-control <?php print(is_invalid($UFORM->getNameError())) ?>" id="new_user_name" name="new_user_name" placeholder="<?php print($EDITUSER->getName()) ?>"><?php print($UFORM->getNameValue()) ?></textarea>
            </div>
        </div>

        <div>
            <div>
                <h5>Csoport módosítása:</h5>
            </div>
            <div>

                <label for="groupname">Válasszon csoportot:</label>

                <select id="groupname" name="groupname">
                    <?php

                    foreach ($GROUPS as $group){
                        print('<option class="form-check-input'. is_invalid($UFORM->getGroupError()).'" value="'.$group.'">'.$group.'</option>');
                    }
                    ?>
                </select>
            </div>

            <div class="form-group row">
                <div class="col-sm-6 offset-sm-2">
                    <button name="submit" class="btn btn-primary">Módosítás</button>
                </div>

            </div>
        </div>
