<?php
/** Variables:
 * @var Dataform $FORM
 * @var string $TYPE
 */

/**
 * @param string|null $err  the error string
 */
function is_invalid($err) {
    if (!is_null($err)) {
        return ' is-invalid';
    }
}
?>

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-dark"><?php print($TYPE) ?> feltöltése:</h1>
    </div>
    <div class="text-dark">

            <?php
            if($TYPE == "Szöveg"){
                print('<div>
                <textarea class="form-control'.is_invalid($FORM->getNameError()).'" id="comment" name="txtfile" placeholder="Ide lehet írni a szöveget!">'. $FORM->getNameValue() .'</textarea>
            </div>');
            }elseif ($TYPE == "Kép"){
                print('<div>
                            <input type="file" class="form-control-file'.is_invalid($FORM->getNameError()).'" name="file[]" id="file" accept="image/*" multiple><br><br>
                        </div>');
            }elseif($TYPE == "Videó"){
                print('<div>
                            <input type="file" class="form-control-file'.is_invalid($FORM->getNameError()).'" name="file" accept="video/*"><br><br>
                        </div>');
            }
            ?>

            <div>
                <p></p>
            </div>
            <div>
                <div>
                    <h5>Időpontok beállítása:</h5>
                </div>
                <div id="time1">
                    <label for="when">Megjelenés kezdete:</label>
                    <input class="form-control<?php echo is_invalid($FORM->getStartError()); ?>" type="datetime-local" id="starttime" name="starttime" value="2020-06-29T20:20:00<?php /*echo $FORM->getStartValue(); */?>">
                </div>
                <div id="time2">
                    <label for="when">Megjelenés vége:</label>
                    <input class="form-control<?php echo is_invalid($FORM->getFinishError()); ?>" type="datetime-local" id="finishtime" name="finishtime" value="2020-07-30T20:20:00<?php /*echo $FORM->getStartValue();*/ ?>">
                </div>
            </div>
            <div>
                <p></p>
            </div>

            <div>
                <div>
                    <h5>Prioritás beállítása:</h5>
                </div>
                <div>
                    <input class="form-check-input<?php echo is_invalid($FORM->getPriorityError()); ?>" type="radio" name="priority" id="priority_on" value="on"
                        <?php if($FORM->getPriorityValue() == 'on'){print("checked");} ?>>
                    <label name="priority" class="form-check-label" for="priority_on">Van prioritása</label><br>
                </div>
                <div>
                    <input class="form-check-input<?php echo is_invalid($FORM->getPriorityError()); ?>" type="radio" name="priority" id="priority_off" value="off"
                        <?php if($FORM->getPriorityValue() == 'off'){print("checked");} ?>>
                    <label name="priority" class="form-check-label" for="priority_off">Nincs prioritása</label><br>
                </div>


                <div class="col-sm-4">
                    <small class="text-danger">
                        <?php echo $FORM->getPriorityError(); ?>
                    </small>
                </div>

            </div>
            <div>
                <p></p>
            </div>

            <div>
                <div>
                    <h5>Ismétlés beállítása:</h5>
                    <h7><u> Felépítés:</u> <b>     óra:perc:hónap:nap:hét_napja</b> </h7>
                    <p></p>
                    <ul>
                        <li><b>óra: </b> 0-23 vagy *</li>
                        <li><b>perc: </b> 0-59 vagy *</li>
                        <li><b>hónap: </b> 1-12 vagy *</li>
                        <li><b>nap: </b> 1-31 vagy *</li>
                        <li><b>hét_napja: </b> 1-7 vagy *</li>
                    </ul>
                    <h7><u> Használati útmutató:</u></h7>
                    <ul>
                        <li><b>: jelentése: </b> elemek elválasztása</li>
                        <li><b>* jelentése: </b> minden</li>
                        <li><b>*/n jelentése: </b> minden n. intervallumon</li>
                        <li><b>n-m jelentése: </b> n és m közötti tartományon</li>
                        <li><b>Több periodikusság megadása , (vessző) segítségével elválasztva!</b></li>
                    </ul>
                    <h7><u> Példák használatra:</u></h7>
                    <ul>
                        <li><b>23:45:*:*:6</b> -> Minden szombat 23:45-kor elvégzi a megosztást a korábban megadott megosztási intervallumban.</li>
                        <li><b>1,2,3:*/5:*:*:*</b> -> Az első, második és harmadik óra minden ötödik percében elvégzi a megosztást a korábban megadott megosztási intervallumban.</li>
                    </ul>
                </div>

                <div>
                    <label class="form-check-label" for="periodicity">Periodikusság megadása</label>
                    <input class="form-control" type="text" id="periodicity" name="periodicity" placeholder="óra:perc:hónap:nap:hét_napja">
                </div>
                <p></p>
            </div>

            <div class="form-group row">
                <div class="col-sm-6 offset-sm-2">
                    <button name="submit" class="btn btn-primary">Elküldés</button>
                </div>

    </div>
</div>
