<?php
/**Used variables
 * @var Tv $EDITTV
 * @var TvForm $TVFORM
 * @var array $ACTIONS
 *
 */

/**
 * @param string|null $err  the error string
 */
function is_invalid($err) {
    global $TVFORM;
    if (!is_null($err) && $TVFORM->isSubmitted()) {
        return ' is-invalid';
    }
}
?>

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-dark">TV <b><?php print($EDITTV->getId()) ?></b> adatainak módosítása</h1>
    </div>
    <div class="text-dark">
        <div>
            <div>
                <h5>Név módosítása:</h5>
            </div>
            <div>
                <textarea class="form-control <?php print(is_invalid($TVFORM->getNameError())) ?>" id="new_tv_name" name="new_tv_name" placeholder="<?php print($EDITTV->getId()) ?>"><?php print($TVFORM->getNameValue()) ?></textarea>
            </div>
        </div>
        <div>
            <div>
                <h5>Jogosultság ID módosítása:</h5>
            </div>
            <div>
                <label for="actid">Válasszon jogosultságot:</label>
                <select id="actid" name="actid" >
                    <?php

                    foreach ($ACTIONS as $act){
                        print('<option class="form-check-input'. is_invalid($TVFORM->getActError()).'" value="'.$act.'">'.$act.'</option>');
                    }
                    ?>
                </select>
            </div>

        <div class="form-group row">
            <div class="col-sm-6 offset-sm-2">
                <button name="submit" class="btn btn-primary">Módosítás</button>
            </div>

        </div>
    </div>
