<?php
/**
 * @var array $TVLIST
 * @var array $DATALIST
 * @var array $USERLIST
 * @var string $DATATYPE
 */
?>

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <?php
        if($DATATYPE == "mytvs"){
            print('<h1 class="h3 mb-0 text-dark"> TV-k listája</h1>');
        }
        if($DATATYPE == "myfiles"){
            print('<h1 class="h3 mb-0 text-dark"> Fájlok listája</h1>');
        }
        ?>
    </div>
    <div>
        <table>
            <ul>
                    <?php
                    if($DATATYPE == "mytvs"){
                        if(User::isAdmin(substr($_SERVER['eppn'], 0, strpos($_SERVER['eppn'], '@')))){
                            foreach ($TVLIST as $tv){
                                print('<tr><td class="text-dark">'.$tv->getId() .'</td>  <td><a type="button" class="btn btn-primary" id="edit" href="edit_item.php?tvitem='.$tv->getId() .'"><i class="fas fa-pen"></i></a></td> <td><a type="button" class="btn btn-primary" id="delete" href="delete_item.php?tvitem='.$tv->getId() .'"><i class="fas fa-times-circle"></i></a></td></tr>');
                            }
                        }

                    }
                    if($DATATYPE == "myfiles"){
                        foreach ($DATALIST as $data){
                            print('<tr><td class="text-dark">'.$data->getName() .'</td>  <td><a type="button" class="btn btn-primary" id="delete" href="delete_item.php?dtitem='.$data->getName() .'"><i class="fas fa-times-circle"></i></a></td></tr>');
                        }
                    }
                    if($DATATYPE == "thisgroup"){
                        foreach ($USERLIST as $group){
                            if(count($group) > 0){
                                print('<tr><th><h1 class="h3 mb-0 text-dark"><b>'. $group[0]["csop_nev"].'</b> csoport listája</h1></th></tr>');
                                foreach ($group as $user){
                                    print('<tr><td class="text-dark">'.$user["nev"].' ('. $user["shibboleth_id"] .')</td>  <td><a type="button" class="btn btn-primary" id="edit" href="edit_item.php?usritem='.$user["shibboleth_id"] .'"><i class="fas fa-pen"></i></a></td> <td><a type="button" class="btn btn-primary" id="delete" href="delete_item.php?usritem='.$user["shibboleth_id"] .'"><i class="fas fa-times-circle"></i></a></td></tr>');
                                }
                            }
                        }
                    }
                    ?>
            </ul>
        </table>
        <?php
        if($DATATYPE == "mytvs") {
            if (User::isAdmin(substr($_SERVER['eppn'], 0, strpos($_SERVER['eppn'], '@')))) {
                print('<a type="button" class="btn btn-primary" id="addTV" href="add_item.php?itemtype=tv"><i class="fas fa-plus"></i> TV hozzáadása</a>');
            }
        }
        if($DATATYPE == "thisgroup"){
            print('<a type="button" class="btn btn-primary" id="addUser" href="add_item.php?itemtype=user"><i class="fas fa-plus"></i> Felhasználó hozzáadása</a>');
        }
        ?>
    </div>
</div>
