<?php
/**
 * Used variables:
 * @var string $PAGE
 * @var array $TVLIST
 */

/**
 *
 * @param string $title
 * @param string $link
 * @param bool $active
 * @return string
 */
function menu_item($title, $link, $active)
{
    $buff = '<a class="text-white'  . ($active ? ' active' : '') . '" href="' . $link . '?type='. $title .'">';
    $buff .= '<div class="btn btn-primary" type="choose" >' . $title. '</div> </a>';
    return $buff;
}
?>

<!DOCTYPE html>
<html lang="hu">

<head>

    <meta charset="utf-8">
    <link rel=icon href="favicon.ico">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">


    <title>PPKE ITK TV kezelő</title>

    <!-- Custom fonts for this template-->
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/onlab.css" rel="stylesheet">
</head>

<body id="page-top">
<form method='POST' action="" enctype="multipart/form-data">
<!-- Page Wrapper -->
<div id="wrapper">

    <!-- Sidebar -->
    <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

        <!-- Sidebar - Brand -->
        <a class="sidebar-brand d-flex align-items-center justify-content-center" href="index.php">
            <div class="sidebar-brand-icon">
                <img class="itk_logo" src="ITK_logo.svg">
            </div>
            <div class="sidebar-brand-text mx-3">PPKE ITK</div>
        </a>

        <!-- Divider -->
        <hr class="sidebar-divider my-0">

        <!-- Nav Item - Dashboard -->
        <li class="nav-item active">
            <a class="nav-link" href="index.php">
                <span class="text-center">Menü</span></a>
        </li>


        <!-- Nav Item - Pages Collapse Menu -->
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
                <i class="fas fa-tv"></i>
                <span>TV-k</span>
            </a>
            <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                        <?php
                        foreach ($TVLIST as $tv){

                            print('<input type="checkbox" id="'.$tv->getId().'" value="'.$tv->getId().'" name="'.$tv->getId().'">');
                            print('<label for="'.$tv->getId().'"> '.$tv->getId().'</label></br>');
                        }
                        ?>
                </div>
            </div>
        </li>

        <!-- Divider -->
        <hr class="sidebar-divider d-none d-md-block">

        <li class="nav-item">
            <a type="button" class="text-center text-white btn" href="settings.php?datatype=myfiles"><i class="fas fa-file"></i> Saját fájlok</a>
        </li>


        <?php
        if(User::isAdmin(substr($_SERVER['eppn'], 0, strpos($_SERVER['eppn'], '@')))){
            print('<hr class="sidebar-divider d-none d-md-block">');
            print('<li class="nav-item">
            <a type="button" class="text-center text-white btn" href="settings.php?datatype=mytvs"><i class="fa fa-cogs"></i> TV kezelő</a>
        </li>');

            print('<hr class="sidebar-divider d-none d-md-block">');
            print('<li class="nav-item">
            <a type="button" class="text-center text-white btn" href="settings.php?datatype=thisgroup"><i class="fa fa-users-cog"></i> Csoport kezelő</a>
        </li>');

            print('<hr class="sidebar-divider d-none d-md-block">');
            print('<li class="nav-item">
            <a type="button" class="text-center text-white btn" href="all_shares.php"><i class="fa fa-share-alt"></i> Összes megosztás</a>
        </li>');
        }
        ?>

        <!-- Divider -->
        <hr class="sidebar-divider d-none d-md-block">

    </ul>
    <!-- End of Sidebar -->

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar -->
            <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                <!-- Sidebar Toggle (Topbar) -->
                <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                    <i class="fa fa-bars"></i>
                </button>

                <!-- Topbar Navbar -->
                <ul id="contentnavbar" class="navbar-nav ml-auto">
                    <div>
                        <?php echo menu_item('Szöveg',    'upload.php', $PAGE == 'upload'); ?>
                        <?php echo menu_item('Kép', 'upload.php', $PAGE == 'upload'); ?>
                        <?php echo menu_item('Videó',        'upload.php', $PAGE == 'upload'); ?>
                    </div>

                    <div id="username">
                        <?php
                        print('<h6>'.$_SERVER['displayName'].'</h6>');
                        ?>
                    </div>

                </ul>

            </nav>
            <!-- End of Topbar -->