<?php


class UserForm
{
    /** @var string */
    protected $name;
    /** @var string */
    protected $old_name;
    /** @var int */
    protected $group;

    /** @var string|null  */
    protected $error_name = null;
    /** @var int|null  */
    protected $error_group = null;

    /** @var bool  */
    private $is_submitted = false;
    /** @var bool  */
    private $is_valid = false;

    /** @var PDO  */
    private $conn;


    /**
     * UserForm constructor.
     */
    public function __construct($POST_DATA, $old){

        // Initialize DB connection
        $db = DB::getInstance();
        $this->conn = $db->getConnection();

        if(!is_null($POST_DATA)){
            $this->name = $POST_DATA['new_user_name'] ?? null;
            $this->group = $POST_DATA['groupname'] ?? null;

            $this->is_submitted = isset($POST_DATA['submit']);
        }
        $stmt = $this->conn->prepare('SELECT nev FROM felhasznalok WHERE shibboleth_id = :shib');
        $stmt->bindParam(':shib', $old);
        $stmt->execute();
        $this->old_name = $stmt->fetch(PDO::FETCH_COLUMN);

    }

    /**
     * OTHER FUNCTIONS
     */

    public function validate(){
        $this->error_name = $this->validateName()  ? null : 'A név megadása kötelező!';
        $this->error_group = $this->validateGroup()  ? null : 'A jog kiválasztása kötelező!';

        $this->is_valid = is_null($this->error_name) && is_null($this->error_group);
    }

    public function edit(){
        try{
            $new_gid = "";
            $stmt = $this->conn->prepare('SELECT csoport_id FROM csoportok WHERE nev = :new_name');
            $stmt->bindParam(':new_name', $this->group);
            $stmt->execute();
            $new_gid = $stmt->fetch(PDO::FETCH_COLUMN);

            $stmt3 = $this->conn->prepare('UPDATE felhasznalok SET nev = :new_name, csoport_id = :new_gid WHERE nev = :old_name');
            $stmt3->bindParam(':new_name', $this->name);
            $stmt3->bindParam(':new_gid', $new_gid);
            $stmt3->bindParam(':old_name', $this->old_name);
            $stmt3->execute();

        }catch (Exception $e) {
            echo "Error!";
        }
    }

    public function add($POST_DATA){

        if($POST_DATA){
            try{
                $stmt = $this->conn->prepare('SELECT csoport_id FROM csoportok WHERE nev = :groupname');
                $stmt->bindParam(':groupname', $POST_DATA['groupname']);
                $stmt->execute();
                $group_id = $stmt->fetch(PDO::FETCH_COLUMN);

                $stmt2 = $this->conn->prepare('INSERT INTO felhasznalok (shibboleth_id, nev, csoport_id) VALUES (:u_shib, :u_nev, :u_csop)');
                $stmt2->bindParam(':u_shib', $POST_DATA['new_user_shib']);
                $stmt2->bindParam(':u_nev', $POST_DATA['new_user_name']);
                $stmt2->bindParam(':u_csop', $group_id);
                $stmt2->execute();

            }catch (Exception $e) {
                echo "Error!";
            }
        }
    }

    /**
     * GETTERS
     */

    public function isSubmitted() {
        return $this->is_submitted;
    }

    public function isValid() {
        return $this->is_valid;
    }

    public function getNameValue() {
        return $this->name;
    }

    public function getNameError() {
        return $this->error_name;
    }

    public function getGroupValue() {
        return $this->group;
    }

    public function getGroupError() {
        return $this->error_group;
    }

    /**
     * VALIDATE FUNCTIONS
     */
    private function validateName(){
        return strlen($this->name) > 0;
    }
    private function validateGroup(){
        return is_string($this->group);
    }
}