<?php

require_once '../models/db.php';

class User
{
    /** @var string */
    protected $shib;
    /** @var string */
    protected $name;
    /** @var int */
    protected $group_num;
    /** @var PDO  */
    private $conn;


    /**
     * User constructor
     * @param string $shib
     * @param string $name
     * @param int $group_num
     */
    public function __construct($shib, $name, $group_num)
    {
        $db = DB::getInstance();
        $this->conn = $db->getConnection();

        $this->shib = $shib;
        $this->name = $name;
        $this->group_num = $group_num;
    }

    /**
     * Find a user in the DB by (shib/)name.
     * @param string $id
     * @return User|null
     */
    public static function find($id) {
        // Initialize DB connection
        $db = DB::getInstance();
        $conn = $db->getConnection();


        $stmt = $conn->prepare('SELECT * FROM felhasznalok WHERE shibboleth_id = :shib');
        $stmt->bindParam(':shib', $id);
        $stmt->execute();

        if($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            return new User($row['shibboleth_id'], $row['nev'], $row['csoport_id']);
        } else {
            return null;
        }
    }


    /**
     * GETTERS
     */

    public function getShib() {
        return $this->shib;
    }

    public function getName() {
        return $this->name;
    }

    public function getGroupID() {
        return $this->group_num;
    }

    /** Visszaadja az adott felhasználóhoz tartozó csoport nevét
     * @return mixed
     */
    public function getGroupName() {

        $stmt = $this->conn->prepare('select csoportok.nev from csoportok inner join felhasznalok on csoportok.csoport_id = felhasznalok.csoport_id where felhasznalok.shibboleth_id = :shib');
        $stmt->bindParam(':shib', $this->shib);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_COLUMN);
    }

    public function getDataID() {
        return $this->data_id;
    }

    /** Felhasználó jogosultságainak lekérése
     * @param string $id
     * @return string activity
     *
     */
    public static function getActivity($id){

        // Initialize DB connection
        $db = DB::getInstance();
        $conn = $db->getConnection();

        $stmt = $conn->prepare('SELECT jogosultsagok.tevekenysegek FROM jogosultsagok INNER JOIN csoportok ON jogosultsagok.id = csoportok.jogosultsagok INNER JOIN felhasznalok ON felhasznalok.csoport_id = csoportok.csoport_id WHERE felhasznalok.shibboleth_id = :id');
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_COLUMN);
    }

    /** Lekéri a DB-ben lévő VIEW adatait, ha az illető jogosult rá - vagyis ha adminisztrátor
     * @param string $id
     * @return mixed
     */
    public static function getView($id){

        // Initialize DB connection
        $db = DB::getInstance();
        $conn = $db->getConnection();

        $statement = $conn->prepare('select jogosultsagok.tevekenysegek FROM felhasznalok INNER JOIN csoportok ON felhasznalok.csoport_id = csoportok.csoport_id INNER JOIN jogosultsagok ON csoportok.jogosultsagok = jogosultsagok.id WHERE felhasznalok.shibboleth_id = :id');
        $statement->bindParam(':id', $id);
        $statement->execute();
        $activity = $statement->fetch(PDO::FETCH_COLUMN);
        $good_act = 'edit';

        if(strpos($activity, $good_act) !== false){
            $stmt = $conn->prepare('SELECT * FROM megosztasok_adatai');
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }

    /** Adott felhasználó jogosultság ID-ját adja vissza
     * @return int accesid
     */
    public function getAccesID(){
        $statement = $this->conn->prepare("Select jogosultsagok from csoportok where csoport_id = :g_id");
        $statement->bindParam(':g_id', $this->group_num);
        $statement->execute();
        return $statement->fetch(PDO::FETCH_COLUMN);
    }

    /** Megmondja az adott ID-jú felhasználó admin-e
     * @param $id
     * @return bool
     */
    public static function isAdmin($id){
        if(strpos(self::getActivity($id), 'edit') !== false){
            return true;
        }
        return false;
    }


    /** Visszaadja a jogosultság id-ját az adott id-jú felhasználónak
     * @param $id
     * @return mixed
     */
    public static function getAccesNum($id){
        // Initialize DB connection
        $db = DB::getInstance();
        $conn = $db->getConnection();

        $statement = $conn->prepare("select csoportok.jogosultsagok FROM csoportok INNER JOIN felhasznalok ON csoportok.csoport_id = felhasznalok.csoport_id WHERE felhasznalok.shibboleth_id = :id");
        $statement->bindParam(':id', $id);
        $statement->execute();
        return intval($statement->fetch(PDO::FETCH_COLUMN));
    }

    /**
     * Adott felhasználó törlése az adataival+megosztásaival együtt
     */
    public function delete(){
        $stmt2 = $this->conn->prepare('DELETE adatok, tv_adat, felhasznalok FROM adatok INNER JOIN tv_adat ON adatok.fajl_id = tv_adat.fajl_id INNER JOIN felhasznaloi_fajlok ON adatok.fajl_id = felhasznaloi_fajlok.adat_id INNER JOIN felhasznalok ON felhasznalok.shibboleth_id = felhasznaloi_fajlok.user_shib WHERE felhasznalok.shibboleth_id = :id');
        $stmt2->bindParam(':id', $this->shib);
        $stmt2->execute();
    }


    /** Összes csoport nevét visszaadja, ha aki épp használja az eszközt az Admin
     * @param $userid
     * @return array
     */
    public function getAllGroups($userid){
        if(self::isAdmin($userid)){
            $stmt = $this->conn->prepare('SELECT nev FROM csoportok');
            $stmt->execute();
            $all_group = $stmt->fetchAll(PDO::FETCH_COLUMN);
            return $all_group;
        }
    }

}