<?php

require_once '../models/db.php';
require_once '../models/tv.php';


class Tvlist
{
    /** @var array<Tv>  */
    protected $tvlist;
    /** @var int */
    protected $jog;

    /** @var PDO  */
    private $conn;


    /**
     * DataList constructor.
     * @param int $jog
     * Visszaadja az összes DB-ben lévő fájl listáját az adataival együtt
     */
    public function __construct($jog) {
        // Initialize DB connection
        $db = DB::getInstance();
        $this->conn = $db->getConnection();

        $this->tvlist = [];
        $this->jog = $jog;

        // Select all products from DB
        $stmt = $this->conn->prepare('SELECT tv_id FROM jogosultsag_tv WHERE jogosultsag_id = :jog_id');
        $stmt->bindParam(':jog_id', $this->jog);
        $stmt->execute();
        $list = [];

        while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $list[] = new Tv($row['tv_id']);
        }
        $this->tvlist = $list;
    }

    /**
     * GETTERS
     * Adott csoport számára rendelkezésre álló TV-k listája
     */

    public function getTvlist()
    {
        return $this->tvlist;
    }


}