<?php


class TvForm
{
    /** @var string */
    protected $name;
    /** @var string */
    protected $old_name;
    /** @var int */
    protected $act;

    /** @var string|null  */
    protected $error_name = null;
    /** @var int|null  */
    protected $error_act = null;

    /** @var bool  */
    private $is_submitted = false;
    /** @var bool  */
    private $is_valid = false;

    /** @var PDO  */
    private $conn;


    /**
     * TvForm constructor.
     * @param $name
     * @param $act
     */
    public function __construct($POST_DATA, $old){

        // Initialize DB connection
        $db = DB::getInstance();
        $this->conn = $db->getConnection();

        if(!is_null($POST_DATA)){
            $this->name = $POST_DATA['new_tv_name'] ?? null;
            $this->act = $POST_DATA['actid'] ?? null;

            $this->is_submitted = isset($POST_DATA['submit']);
        }
        $this->old_name = $old;

    }

    /**
     * OTHER FUNCTIONS
     */

    public function validate(){

        $this->error_name = $this->validateName()  ? null : 'A név megadása kötelező!';
        $this->error_act = $this->validateAct()  ? null : 'A jog kiválasztása kötelező!';

        $this->is_valid = is_null($this->error_name) && is_null($this->error_act);

    }

    public function edit(){
        try{
            $stmt = $this->conn->prepare('UPDATE tv SET tv_id = :new_id WHERE tv_id = :old_id');
            $stmt->bindParam(':old_id', $this->old_name);
            $stmt->bindParam(':new_id', $this->name);
            $stmt->execute();

            $stmt3 = $this->conn->prepare('UPDATE tv_adat SET tv_id = :new_id WHERE tv_id = :old_id');
            $stmt3->bindParam(':old_id', $this->old_name);
            $stmt3->bindParam(':new_id', $this->name);
            $stmt3->execute();

            $stmt2 = $this->conn->prepare('UPDATE jogosultsag_tv SET tv_id = :new_tv, jogosultsag_id = :new_act WHERE tv_id = :old_id');
            $stmt2->bindParam(':old_id', $this->old_name);
            $stmt2->bindParam(':new_tv', $this->name);
            $stmt2->bindParam(':new_act', $this->act);
            $stmt2->execute();

        }catch (Exception $e) {
            echo "Error!";
        }
    }

    public function add($POST_DATA){
        try{
            $stmt = $this->conn->prepare('INSERT INTO tv (tv_id) VALUES (:id)');
            $stmt->bindParam(':id', $POST_DATA['new_tv_name']);
            $stmt->execute();

            $stmt2 = $this->conn->prepare('INSERT INTO jogosultsag_tv (tv_id, jogosultsag_id) VALUES (:tv, :jog)');
            $stmt2->bindParam(':tv', $POST_DATA['new_tv_name']);
            $stmt2->bindParam(':jog', $POST_DATA['actid']);
            $stmt2->execute();

        }catch (Exception $e) {
            echo "Error!";
        }
    }

    /**
     * GETTERS
     */

    public function isSubmitted() {
        return $this->is_submitted;
    }

    public function isValid() {
        return $this->is_valid;
    }

    public function getNameValue() {
        return $this->name;
    }

    public function getNameError() {
        return $this->error_name;
    }

    public function getActValue() {
        return $this->act;
    }

    public function getActError() {
        return $this->error_act;
    }

    /**
     * VALIDATE FUNCTIONS
     */
    private function validateName(){
        return strlen($this->name) > 0;
    }
    private function validateAct(){
        return is_numeric($this->act);
    }
}