<?php

require_once '../models/db.php';
require_once '../models/data.php';

class Datalist
{
    /** @var array<Data>  */
    protected $dtlist;

    /** @var PDO  */
    private $conn;


    /**
     * DataList constructor.
     * @param string $userid
     * Visszaadja az összes DB-ben lévő fájl listáját az adataival együtt ami az adott felhasználóhoz tartozik
     *
     */
    public function __construct($userid) {
        $db = DB::getInstance();
        $this->conn = $db->getConnection();

        $stmt = $this->conn->prepare('Select adatok.fajl_id, adatok.mettol, adatok.meddig, adatok.prioritas, adatok.periodikussag FROM adatok inner join felhasznaloi_fajlok on adatok.fajl_id = felhasznaloi_fajlok.adat_id inner join felhasznalok on felhasznalok.shibboleth_id = felhasznaloi_fajlok.user_shib where felhasznalok.shibboleth_id = :uid');
        $stmt->bindParam(':uid', $userid);
        $stmt->execute();

        $this->dtlist = [];

        while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $this->dtlist[] = new Data($row['fajl_id'], $row['mettol'], $row['meddig'], $row['prioritas'], $row['periodikussag']);
        }
    }

    /**
     * GETTERS
     */

    public function getDatalist()
    {
        return $this->dtlist;
    }

    /** Visszatér az adott nevű elemmel ha tartalmazza a lista
     * @param $id
     * @return mixed|null
     */
    public function getData($id){
        foreach ($this->dtlist as $dt){
            if($dt->getName() == $id){
                return $dt;
            }
        }
        return NULL;
    }

    /**
     * OTHER FUNCTIONS
     */

    /**
     * Adott felhasználóhoz tartozó összes adat törlése
     * @param string $userid
     */
    public function deleteMyDatalist($userid){
        // Initialize DB connection
        $db = DB::getInstance();
        $this->conn = $db->getConnection();

        $stmt = $this->conn->prepare('DELETE * FROM (felhasznalok INNER JOIN felhasznaloi_fajlok ON felhasznalok.shibboleth_id = felhasznaloi_fajlok.user_shib) 
            INNER JOIN adatok ON adatok.fajl_id = felhasznaloi_fajlok.adat_id WHERE felhasznalok.shibboleth_id = :id');
        $stmt->bindParam(':id', $userid);
        $stmt->execute();
        $this->dtlist = NULL;
    }

    /** Egy adott fájl törlése
     * @param $dataid
     */
    public function deletMyData($dataid){
        $dt = $this->getData($dataid);
        if(!is_null($dt)){
            $dt->delete();
            unset($this->dtlist[$dt]);
        }
    }

}