<?php

require_once '../models/db.php';

class Data
{
    /** @var int */
    protected $name;
    /** @var string */
    protected $start_time;
    /** @var string */
    protected $finish_time;
    /** @var bool */
    protected $priority;
    /** @var string */
    protected $periodicity;

    /**
     * Data constructor.
     * @param string $name
     * @param string $start_time
     * @param string $finish_time
     * @param int $priority
     * @param string $periodicity
     */
    public function __construct($name, $start_time, $finish_time, $priority, $periodicity)
    {
        $this->name = $name;
        $this->start_time = $start_time;
        $this->finish_time = $finish_time;
        $this->priority = $priority;
        $this->periodicity = $periodicity;
    }

    /**
     * Find a product in the DB by ID. The function returns the Product (as object) or null if ID not found
     * @param string $filename
     * @return Data|null
     */
    public static function find($filename)
    {
        // Initialize DB connection
        $db = DB::getInstance();
        $conn = $db->getConnection();

        // Select all products from DB
        $stmt = $conn->prepare('SELECT * FROM adatok WHERE fajl_id = :id');
        $stmt->bindParam(':id', $filename);
        $stmt->execute();

        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            return new Data($row['fajl_id'], $row['mettol'], $row['meddig'], $row['prioritas'], $row['periodikussag']);
        } else {
            return null;
        }
    }

    /**
     * Adott adat törlése
     */
    public function delete(){

        // Initialize DB connection
        $db = DB::getInstance();
        $conn = $db->getConnection();

        //A tv_adat-bol is ki kell torolni

        $stmt2 = $conn->prepare('DELETE FROM tv_adat WHERE fajl_id = :id');
        $stmt2->bindParam(':id', $this->name);
        $stmt2->execute();

        // DB-bol kitorlom az adatok tablabol az adott fajlt
        $stmt = $conn->prepare('DELETE FROM adatok WHERE fajl_id = :id');
        $stmt->bindParam(':id', $this->name);
        $stmt->execute();
    }

    /**
     * GETTERS
     */

    public function getName()
    {
        return $this->name;
    }

    public function getStart()
    {
        return $this->start_time;
    }

    public function getFinish()
    {
        return $this->finish_time;
    }

    public function getPriority()
    {
        return $this->priority;
    }

    public function getPeriodicity()
    {
        return $this->periodicity;
    }
}