{
  description = "Nádudvari Ákos BSc szakdolgozat dokumentum forrása";

  inputs = {
    nixpkgs.url = "github:NixOS/nixpkgs/nixos-unstable";
    flake-parts = {
      url = "github:hercules-ci/flake-parts";
      inputs.nixpkgs-lib.follows = "nixpkgs";
    };
    treefmt-nix = {
      url = "github:numtide/treefmt-nix";
      inputs.nixpkgs.follows = "nixpkgs";
    };
  };

  outputs = inputs @ { self, flake-parts, ... }:
    flake-parts.lib.mkFlake { inherit inputs; } {
      imports = [
        ((import ./nix/flake-module.nix) self)
        inputs.treefmt-nix.flakeModule
      ];
      systems = [ "x86_64-linux" "aarch64-linux" "aarch64-darwin" "x86_64-darwin" ];
      perSystem = { config, self', inputs', pkgs, system, ... }: {
        document.source = ./src;
        document.mainFile = "szakdolgozat";
        packages.default = config.packages.document;
        devShells.default = config.devShells.document;

        treefmt.programs = {
          nixpkgs-fmt.enable = true;
          latexindent = {
            enable = true;
            package = config.document.texlive;
          };
        };
      };
    };
}
