function [] = imageColorStatistics(name)
    yAxisR = zeros(1,256);
    yAxisG = zeros(1,256);
    yAxisB = zeros(1,256);
    
    yAxisH = zeros(1,361);
    yAxisS = zeros(1,101);
    yAxisV = zeros(1,101);
    
    %images = ["hartya01.jpg", "hartya02.jpg", "hartya03.jpg", "hartyaDark.jpg"];
    images = ["erezet01.jpg"];
    for db = 1:size(images, 2)
        IMG = imread(images(db));
        IMGHSV = rgb2hsv(IMG);
        for x = 1:size(IMG, 2)
            for y = 1:size(IMG, 1)
                R = IMG(y,x,1);
                G = IMG(y,x,2);
                B = IMG(y,x,3);
                H = floor(IMGHSV(y,x,1)*360)+1;
                S = floor(IMGHSV(y,x,2)*100)+1;
                V = floor(IMGHSV(y,x,3)*100)+1;
                if R > 220
                    continue
                end
                yAxisR(R) = yAxisR(R)+1;
                yAxisG(G) = yAxisG(G)+1;
                yAxisB(B) = yAxisB(B)+1;
                
                %round(IMGHSV(x,y,1)*360)+1
                %round(IMGHSV(x,y,2)*100)+1
                %round(IMGHSV(x,y,3)*100)+1
                yAxisH(H) = yAxisH(H)+1;
                yAxisS(S) = yAxisS(S)+1;
                yAxisV(V) = yAxisV(V)+1;
            end
        end
    end
    xAxis = 0:255;
    figure('Name', strcat(name, 'RGB'))
    plot(xAxis, yAxisR, '-r', xAxis, yAxisG, '-g', xAxis, yAxisB, '-b')
    
    figure('Name', strcat(name, 'HSV'))
    plot(1:361, yAxisH, '-r', 1:101, yAxisS, '-g', 1:101, yAxisV, '-b')
    
end